model Ex10_8

parameter Real L(unit="cm")=2*10^(-4);
parameter Real Cox(unit="F/cm^2")=6.9*10^(-8);
parameter Real V_DS(unit="V")=0.10;
parameter Real ID1(unit="A")=35*10^(-6);
parameter Real ID2(unit="A")=75*10^(-6);
parameter Real V_GS1(unit="V")=1.5;
parameter Real V_GS2(unit="V")=2.5;
parameter Real W(unit="cm")=15*10^(-4)"width of MOSFET";

Real mu_n(unit="cm^2/V-s")"inversion carrier mobility";

equation

ID2-ID1=(W*mu_n*Cox*(V_GS2-V_GS1)*V_DS)/(L);


end Ex10_8;