model Ex10_9
parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=3*10^16"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real epsilon_ox(unit="F.cm^(-1)")=3.9*8.85*10^(-14);
parameter Real t_ox(unit="cm")=200*10^(-8)"thickness";
parameter Real V_SB(unit="V")=1;

Real Vt(unit="ev");
Real fi_fp(unit="V");
Real Cox(unit="F/cm^2");
Real gamma"body effect coefficient";
Real delta_VT(unit="V")"threshold voltage";

equation

Cox=epsilon_ox/t_ox;
Vt=(k*T)/e;
fi_fp=Vt*log(Na/ni);
gamma=sqrt(2*e*epsilon_s*Na)/Cox;
delta_VT=gamma*(sqrt(2*fi_fp+V_SB)-sqrt(2*fi_fp));


end Ex10_9;