model Ex11_1

parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=2*10^16"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real VT(unit="V")=0.4;
parameter Real V_GS(unit="V")=1;
parameter Real V_DS(unit="V")=2.5;
parameter Real L(unit="cm")=10^(-4);

Real Vt(unit="ev");
Real fi_fp(unit="V");
Real V_DS_sat(unit="V");
Real delta_V_DS(unit="V");
Real delta_L(unit="cm");
Real Ratio"=I'D/ID  the ratio of actual drain current compared to the ideal value";

equation

Vt=(k*T)/e;
fi_fp=Vt*log(Na/ni);
V_DS_sat=V_GS-VT;
delta_V_DS=V_DS-V_DS_sat;
delta_L=sqrt((2*epsilon_s)/(e*Na))*(sqrt(fi_fp+V_DS_sat+delta_V_DS)-sqrt(fi_fp+V_DS_sat));
Ratio=L/(L-delta_L);





end Ex11_1;