model Ex12_3

parameter Real NB(unit="cm^(-3)")=5*10^15"doping concentration";
parameter Real DB(unit="cm^(2)/s")=20;
parameter Real xB(unit="cm")=0.80*10^(-4);
parameter Real xBE(unit="cm")=0.10*10^(-4);
parameter Real VBE(unit="V")=0.50;
parameter Real Vt(unit="V")=0.0259;
parameter Real LB(unit="cm")=10*10^(-4);
parameter Real To_0(unit="s")=10^(-7);
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";

Real delta"recombination factor";
Real Jro(unit="A/cm^2")"recombination factor";
Real Jso(unit="A/cm^2")"recombination factor";

equation

Jro=(e*xBE*ni)/(2*To_0);
Jso=(e*DB*(ni^2/NB))/(LB*tanh(xB/LB));
delta=1/(1+(Jro/Jso)*exp(-VBE/(2*Vt)));

end Ex12_3;