model Ex12_7

parameter Real NB(unit="cm^(-3)")=10^16"doping concentration";
parameter Real NE(unit="cm^(-3)")=10^18"doping concentration";
parameter Real DB(unit="cm^(2)/s")=25;
parameter Real DE(unit="cm^(2)/s")=10;
parameter Real xB(unit="cm")=0.70*10^(-4);
parameter Real xE(unit="cm")=0.50*10^(-4);
parameter Real V_BE(unit="V")=0.65;
parameter Real To_EO(unit="s")=10^(-7);
parameter Real To_BO(unit="s")=5*10^(-7);
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real Jro(unit="A/cm^2")=5*10^(-8)"recombination factor";
parameter Real T(unit="K")=300"temperature";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";

Real p_EO(unit="cm^(-3)");
Real n_BO(unit="cm^(-3)");
Real LE(unit="cm");
Real LB(unit="cm");
Real gamma"emitter injection efficiency factor";
Real alpha_T"base transport factor";
Real delta"recombination factor";
Real Jso(unit="A/cm^2")"recombination factor";
Real alpha"common-base current gain";
Real Bita"common-emitter current gain";

equation

p_EO=ni^2/NE;
n_BO=ni^2/NB;
LE=sqrt(DE*To_EO);
LB=sqrt(DB*To_BO);

gamma=1/(1+(NB/NE)*(DE/DB)*(xB/xE));
alpha_T=1/cosh(xB/LB);
delta=1/(1+(Jro/Jso)*exp(-(e*V_BE)/(2*k*T)));
Jso=(e*DB*(ni^2/NB))/(LB*tanh(xB/LB));
alpha=gamma*alpha_T*delta;
Bita=alpha/(1-alpha);

/*The  answer may slightly vary due to  rounding off values*/

end Ex12_7;