model Ex13_6

parameter Real Na(unit="cm^(-3)")=10^18"doping concentration";
parameter Real Nd(unit="cm^(-3)")=3*10^15"doping concentration";
parameter Real T(unit="K")=300"temperature";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real ni(unit="cm^(-3)")=1.8*10^(6);
parameter Real a(unit="cm")=0.70*10^(-4);
parameter Real h(unit="cm")=0.60*10^(-4);
parameter Real epsilon_s(unit="F.cm^(-1)")=13.1*8.85*10^(-14);

Real Vpo(unit="V")"internal pinchoff voltage";
Real VT(unit="V")"Threshold voltage";
Real Vbi(unit="V")"built-in potential barrier";
Real Vt(unit="V");
Real VGS(unit="V")"forword bias gate voltage";

equation

Vpo=e*a^2*Nd/(2*epsilon_s);
Vt=k*T/e;
Vbi=Vt*log(Na*Nd/ni^2);
VT=Vbi-Vpo;
VGS=Vbi-e*h^2*Nd/(2*epsilon_s);

end Ex13_6;