model Ex13_7

parameter Real L(unit="cm")=1.2*10^(-4);
parameter Real epsilon_s(unit="F.cm^(-1)")=13.1*8.85*10^(-14);
parameter Real a(unit="cm")=0.70*10^(-4);
parameter Real mu_n(unit="cm^2/V-s")=8000;
parameter Real VGS(unit="V")=0.5;
parameter Real VT(unit="V")=0.24;
Real ID1(unit="A")=75*10^(-6);

Real kn(unit="A/V^2")"conduction parameter";
Real W(unit="cm")"required channel width";


equation

ID1=kn*(VGS-VT)^2;
kn=(mu_n*epsilon_s*W/(2*L*a));

end Ex13_7;