model Ex13_9

parameter Real L(unit="cm")=5*10^(-4);
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real a(unit="cm")=0.60*10^(-4);
parameter Real mu_n(unit="cm^2/V-s")=1000;
parameter Real Nd(unit="cm^(-3)")=10^16"doping concentration";
parameter Real pi=Modelica.Constants.pi;
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";

Real fT(unit="GHz")"cutoff frequency";


equation

fT=e*mu_n*Nd*a^2/(2*pi*epsilon_s*10^9*L^2);

end Ex13_9;