model Ex14_2

parameter Real T(unit="K")=300"temperature";
parameter Real Iv_x(unit="W/cm^2")=0.05"=Iv(x)";
parameter Real lembda(unit="um")=0.75;
parameter Real alpha(unit="cm^(-1)")=0.9*10^4;
parameter Real To(unit="s")=10^(-7);
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";

Real hv(unit="ev");
Real E(unit="ev");
Real gdes(unit="cm^(-3)-s^(-1)")"efficiency factor";
Real delta_n(unit="cm^(-3)");

equation

hv=1.24/lembda;
gdes=alpha*Iv_x/(hv*e);
delta_n=gdes*To;
E=hv;

end Ex14_2;