model Ex14_4

parameter Real L(unit="cm")=100*10^(-4)"length";
parameter Real To_p(unit="s")=10^(-6)"minority carrier lifetime";
parameter Real A(unit="cm^2")=10^(-7)"cross section area";
parameter Real V(unit="V")=10"applied voltage";
parameter Real mu_n(unit="cm^2/V-s")=1350;
parameter Real mu_p(unit="cm^2/V-s")=480;

Real tn(unit="s")"electron transit time";
Real gamma_ph"photoconductor gain";

equation

tn=L^2/(mu_n*V);
gamma_ph=(To_p/tn)*(1+mu_p/mu_n);

end Ex14_4;