model Ex14_5

parameter Real To_p0(unit="s")=10^(-7);
parameter Real To_n0(unit="s")=5*10^(-7);
parameter Real Na(unit="cm^(-3)")=10^(16)"doping concentration";
parameter Real Nd(unit="cm^(-3)")=10^(16)"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real Dn(unit="cm^2/s")=25;
parameter Real Dp(unit="cm^2/s")=10;
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real T(unit="K")=300"temperature";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real GL(unit="cm^(-3)-s^(-1)")=10^(21);
parameter Real VR(unit="V")=5"reverse bias voltage";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);

Real Vbi(unit="V");
Real W(unit="cm");
Real JL(unit="A/cm^2")"steady-state photocurrent density";
Real Ln(unit="cm");
Real Lp(unit="cm");
Real Vt(unit="ev");

equation

Ln=sqrt(Dn*To_n0);
Lp=sqrt(Dp*To_p0);
Vt=k*T/e;
Vbi=Vt*log(Na*Nd/ni^2);
W=((2*epsilon_s/e)*((Na+Nd)/(Na*Nd))*(Vbi+VR))^(1/2);
JL=e*(W+Ln+Lp)*GL;


end Ex14_5;