model Ex2_6

parameter Real m0(unit="kg")=9.11*10^(-31) "mass of electron" ;
parameter Real epislon_not(unit="F.m^-1")=8.85*10^(-12)"permittivity of free space";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real h(unit="J.Sec.")=1.054*10^(-34)"Planck's constant";
parameter Real pi=2*Modelica.Math.asin(1.0);
parameter Real n1=1;
parameter Real n2=2;
parameter Real n3=3;
Real E1(unit="ev")"First energy level";
Real E2(unit="ev")"Second energy level";
Real E3(unit="ev")"Third energy level";

equation

E1=-(m0*e^4)/(((4*pi*epislon_not)^2)*2*h^2*n1^2*e);
E2=-(m0*e^4)/(((4*pi*epislon_not)^2)*2*h^2*n2^2*e);
E3=-(m0*e^4)/(((4*pi*epislon_not)^2)*2*h^2*n3^2*e);
end Ex2_6;