model Ex4_1

parameter Real T(unit="K")=300"temperature";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real E(unit="ev")=0.25"energy level";
parameter Real Ef(unit="ev")=0;
parameter Real Nc(unit="cm^(-3)")=2.8*10^(19);
parameter Real q(unit="coulomb")=1.6*10^(-19)"Charge of electron";
Real fF_E"=fF(E)=probability that an energy state at E";
Real n0(unit="cm^(-3)")"=Electron concentration";
Real kT(unit="ev");
equation

fF_E=exp(-((E+(kT/2)-Ef)/(kT)));
n0=Nc*exp(-((E-Ef)/(kT)));
kT=k*T/q;

end Ex4_1;