model Ex4_13

parameter Real T(unit="K")=300"temperature";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real Ea_Ev(unit="ev")=0.045"=Ea-Ev=ionization energy";
parameter Real q(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real Eg(unit="ev")=1.12"Bandgap energy";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
Real EF_Ea(unit="ev")"=EF-Ea";
Real Na(unit="cm^(-3)");

Real kT(unit="ev");
Real EFi_EF(unit="ev")"=EFi-EF";

equation
EF_Ea=3*kT;
kT=(k*T/q);
EFi_EF=Eg/2-Ea_Ev-EF_Ea;
Na=ni*exp(EFi_EF/kT);

/*The  answer may slightly vary due to  rounding off values*/


end Ex4_13;