model Ex4_2

parameter Real T1(unit="K")=400"temperature";
parameter Real T2(unit="K")=300"temperature";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real Ev(unit="ev")=0;
parameter Real Ef(unit="ev")=0.27"Fermi energy";
parameter Real Nv1(unit="cm^(-3)")=1.04*10^(19);
parameter Real q(unit="coulomb")=1.6*10^(-19)"Charge of electron";
Real Nv(unit="cm^(-3)");
Real kT(unit="ev");

Real p0(unit="cm^(-3)")"=hole concentration";
equation

Nv=Nv1*(T1/T2)^(3/2);
p0=Nv*exp(-((Ef-Ev)/(kT)));
kT=(k*T2/q)*(T1/T2);


end Ex4_2;