model Ex4_3

parameter Real T1(unit="K")=250"temperature";
parameter Real T2(unit="K")=300"temperature";
parameter Real T3(unit="K")=400"temperature";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real E(unit="ev")=1.12"bandgap energy of silicon";
parameter Real Nc(unit="cm^(-3)")=2.8*10^(19);
parameter Real Nv(unit="cm^(-3)")=1.04*10^(19);
parameter Real q(unit="coulomb")=1.6*10^(-19)"Charge of electron";
Real ni1(unit="cm^(-3)")"intrinsic carrier concentration in Si at T=250k";
Real ni2(unit="cm^(-3)")"intrinsic carrier concentration in Si at T=400k";
Real kT1(unit="ev");
Real kT2(unit="ev");
equation

kT1=(k*T2/q)*(T1/T2);
ni1^2=Nc*Nv*((T1/T2)^3)*exp(-E/kT1);
kT2=(k*T2/q)*(T3/T2);
ni2^2=Nc*Nv*((T3/T2)^3)*exp(-E/kT2);

/*The  answer may slightly vary due to  rounding off values*/
end Ex4_3;