model Ex4_8

parameter Real T1(unit="K")=300"temperature";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real Ea_Ev(unit="ev")=0.045;
parameter Real Na(unit="cm^(-3)")=10^(16);
parameter Real Nv(unit="cm^(-3)")=1.04*10^(19);
parameter Real q(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real Pa_P0_Pa=0.10"=Pa/(P0+Pa)";
Real kT(unit="ev");
Real T(unit="K")"temperature";

equation

Pa_P0_Pa=1/(1+(Nv/(4*Na))*((T/300)^(3/2))*exp(-((Ea_Ev)/(kT*(T/300)))));
kT=(k*T1/q);



end Ex4_8;