model Ex5_6

parameter Real T(unit="K")=300"temperature";

parameter Real dNdx_dx(unit="cm^(-4)")=-10^19"=d(Nd(x))/d(x)";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real q(unit="coulomb")=1.6*10^(-19)"Charge of electron";
Real kT(unit="Joule");
Real Nd_x(unit="cm^(-3)")"=Nd(x)";
Real x;
Real Ex(unit="V/cm")"electric field";

equation

x=0;
Nd_x=10^16-x*10^19;
kT=k*T;
Ex=-(kT/q)*dNdx_dx/Nd_x;
/*The  answer may slightly vary due to  rounding off values*/

end Ex5_6;