model Ex5_8

parameter Real L(unit="m")=10^(-3);
parameter Real W(unit="m")=10^(-4);
parameter Real d(unit="m")=10^(-5);
parameter Real Ix(unit="A")=10^(-3);
parameter Real Vx(unit="V")=12.5;
parameter Real Bz(unit="tesla")=5*10^(-2);
parameter Real VH(unit="V")=-6.25*10^(-3);
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
Real n(unit="m^(-3)")"electron concentration";
Real mu_n(unit="m^2/V-s")"electron mobility";

equation

n=-(Ix*Bz)/(e*d*VH);
mu_n=(Ix*L)/(e*n*Vx*W*d);


end Ex5_8;