model Ex7_1

parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=2*10^17"doping concentration";
parameter Real Nd(unit="cm^(-3)")=10^(15)"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real q(unit="coulomb")=1.6*10^(-19)"Charge of electron";
Real Vt(unit="ev");
Real Vbi(unit="V")"built-in potential barrier in a pn junction";

equation

Vt=(k*T)/q;
Vbi=Vt*log((Na*Nd)/ni^2);

end Ex7_1;