model Ex7_5

parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=10^16"doping concentration";
parameter Real Nd(unit="cm^(-3)")=10^(15)"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real VR(unit="V")=5;
parameter Real A(unit="cm^2")=10^(-4)"cross-sectional area of the pn junction";
Real Vt(unit="ev");
Real Vbi(unit="V")"built-in potential barrier in a pn junction";
Real C_des(unit="F/cm^2")"junction capacitance";
Real C(unit="F")"Total junction capacitance";

equation

Vt=(k*T)/e;
Vbi=Vt*log((Na*Nd)/ni^2);
C_des=((e*epsilon_s*Na*Nd)/(2*(Na+Nd)*(Vbi+VR)))^(1/2);
C=C_des*A;



end Ex7_5;