model Ex8_4

parameter Real T(unit="K")=300"temperature";
parameter Real To_p0(unit="s")=5*10^(-7);
parameter Real To_n0(unit="s")=5*10^(-7);
parameter Real Na(unit="cm^(-3)")=10^16"doping concentration";
parameter Real Nd(unit="cm^(-3)")=10^(16)"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real Dn(unit="cm^2/s")=25;
parameter Real Dp(unit="cm^2/s")=10;
parameter Real epsilon_r=11.7;
parameter Real mu_n(unit="cm^2/V-s")=1350;
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real Va(unit="V")=0.65"voltage";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
Real Js(unit="A/cm^2")"reverse-saturation current density";
Real J(unit="A/cm^2")"current density";
Real Jn(unit="A/cm^2")"current density";
Real E(unit="V/cm")"electric field in a neutral region of a silicon";

/*The  answer may slightly vary due to  rounding off values*/
equation

Js=(e*ni^2)*((1/Na)*sqrt(Dn/To_n0)+(1/Nd)*sqrt(Dp/To_p0));
J=Js*(exp((e*Va)/(k*T))-1);
Jn=J;
E=Jn/(e*mu_n*Nd);


end Ex8_4;