model Ex8_5

parameter Real T1(unit="K")=300"temperature";
parameter Real T2(unit="K")=310"temperature";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real Eg(unit="ev")=1.12;
parameter Real Va1(unit="V")=0.60"initially biased voltage";
Real Va2(unit="V")"forword bias voltage";
Real Va2_Va1(unit="mV")"Change in the forword-bias voltage for a 10 degree C temperature change";

equation

(Eg-Va2)/(k*T2)=(Eg-Va1)/(k*T1);
Va2_Va1=(Va2-Va1)*1000;

end Ex8_5;