model Ex9_1


parameter Real T(unit="K")=300"temperature";
parameter Real Nc(unit="cm^(-3)")=2.8*10^19"doping concentration";
parameter Real Nd(unit="cm^(-3)")=10^(16)"doping concentration";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real X(unit="V")=4.01;
parameter Real fi_m(unit="V")=4.55;

Real fi_BO(unit="V")"ideal schottky barrier height";
Real fi_n(unit="V");
Real Vbi(unit="V")"built-in potential barrier";
Real xn(unit="cm")"space charge width";
Real Emax(unit="V/cm")"=|Emax|  maximum electric field";

equation

fi_BO=fi_m-X;
fi_n=(k*T/e)*log(Nc/Nd);
Vbi=fi_BO-fi_n;
xn=((2*epsilon_s*Vbi)/(e*Nd))^(1/2);
Emax=(e*Nd*xn)/(epsilon_s);

end Ex9_1;