model Ex9_3

parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real epsilon_s(unit="F.cm^(-1)")=13.1*8.85*10^(-14);
parameter Real pi=Modelica.Constants.pi;
parameter Real E(unit="V/cm")=6.8*10^4"electric field";

Real delta_fi(unit="V")"Schottky barrier lowering";
Real xm(unit="cm")"position of the maximum barrier height";


equation

delta_fi=sqrt((e*E)/(4*pi*epsilon_s));
xm=sqrt((e)/(16*pi*epsilon_s*E));

end Ex9_3;