model Ex10_2

parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=10^15"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real fi_des_m(unit="V")=3.20"fi'_m";
parameter Real X_des(unit="V")=3.25"X'";
parameter Real Eg(unit="ev")=1.12*e;

Real Vt(unit="ev");
Real fi_fp(unit="V");
Real fi_ms(unit="V")"Metal-semiconductor work function difference";


equation

Vt=(k*T)/e;
fi_fp=Vt*log(Na/ni);
fi_ms=fi_des_m-(X_des+Eg/(2*e)+fi_fp);

end Ex10_2;