model Ex11_6

parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=5*10^15"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real epsilon_ox(unit="F.cm^(-1)")=3.9*8.85*10^(-14);
parameter Real t_ox(unit="cm")=180*10^(-8)"thickness";
parameter Real V_FBO(unit="V")=-1.25;
parameter Real VT(unit="V")=0.40;
parameter Real xI(unit="cm")=.15*10^(-4);

Real DI(unit="cm^(-2)");
Real Ns(unit="cm^(-3)");
Real Cox(unit="F/cm^2");
Real Vt(unit="ev");
Real fi_fpO(unit="V");
Real x_dTO(unit="cm")"space charge width";
Real V_TO(unit="V")"The initial pre-implant threshold voltage";

equation

Cox=epsilon_ox/t_ox;
Vt=(k*T)/e;
fi_fpO=Vt*log(Na/ni);
x_dTO=sqrt((4*epsilon_s*fi_fpO)/(e*Na));

V_TO=V_FBO+2*fi_fpO+e*Na*x_dTO/Cox;
VT=V_TO+e*DI/Cox;
Ns-Na=DI/xI;

end Ex11_6;