model Ex11_7


parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real epsilon_ox(unit="F.cm^(-1)")=3.9*8.85*10^(-14);
parameter Real t_ox(unit="cm")=250*10^(-8)"thickness";
parameter Real N(unit="electron-hole pairs per cm^3")=10^18;
parameter Real x(unit="%")=20"percent of the generation holes";

Real Nh(unit="cm^(-2)")"areal density of holes generation";
Real Qdes_ss(unit="C/cm^(-2)")"Surface charge";
Real Cox(unit="F/cm^(-2)")"capacitance";
Real delta_VT(unit="V")"thershold voltage shift";

equation

Nh=N*t_ox;
Qdes_ss=Nh*(x/100)*e;
Cox=epsilon_ox/t_ox;
delta_VT=-Qdes_ss/Cox;

end Ex11_7;