model Ex13_1

parameter Real Na(unit="cm^(-3)")=10^18"doping concentration";
parameter Real Nd(unit="cm^(-3)")=10^16"doping concentration";
parameter Real T(unit="K")=300"temperature";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real a(unit="cm")=0.75*10^(-4);
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);

Real Vpo(unit="V")"internal pinchoff voltage";
Real Vp(unit="V")"pinchoff voltage";
Real Vbi(unit="V")"built-in potential barrier";
Real Vt(unit="V");

equation

Vpo=e*a^2*Nd/(2*epsilon_s);
Vt=k*T/e;
Vbi=Vt*log(Na*Nd/ni^2);
Vp=Vbi-Vpo;

end Ex13_1;