model Ex13_10

parameter Real epsilon_N(unit="F.cm^(-1)")=12.2*8.85*10^(-14);
parameter Real d_d(unit="cm")=500*10^(-8);
parameter Real mu_n(unit="cm^2/V-s")=1000;
parameter Real Nd(unit="cm^(-3)")=10^18"doping concentration";
parameter Real q(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real fi_B(unit="V")=0.85;
parameter Real deltaEc_q(unit="V")=0.22;

Real Vp2(unit="V");
Real Voff(unit="V")"threshold voltage";
Real ns(unit="cm^(-2)");

equation

Vp2=q*Nd*d_d^2/(2*epsilon_N);
Voff=fi_B-deltaEc_q-Vp2;
ns=(epsilon_N/(q*(d_d+100*10^(-8))))*(-Voff);

end Ex13_10;