model Ex13_3

parameter Real L(unit="cm")=10*10^(-4);
parameter Real Na(unit="cm^(-3)")=10^18"doping concentration";
parameter Real Nd(unit="cm^(-3)")=10^16"doping concentration";
parameter Real T(unit="K")=300"temperature";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real a(unit="cm")=0.75*10^(-4);
parameter Real W(unit="cm")=30*10^(-4);
parameter Real mu_n(unit="cm^2/V-s")=1000;
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real VGS(unit="V")=0;

Real Vpo(unit="V")"internal pinchoff voltage";
Real Vbi(unit="V")"built-in potential barrier";
Real Ip1(unit="mA")"pinchoff current";
Real ID1_max(unit="mA")"=ID1(max)=Maximum current";
Real Vt(unit="ev");


equation


Vpo=e*a^2*Nd/(2*epsilon_s);
Vt=k*T/e;
Vbi=Vt*log(Na*Nd/ni^2);
Ip1=mu_n*((e*Nd)^2)*W*a^3/(6*epsilon_s*L)/10^(-3);
ID1_max=Ip1*(1-3*((Vbi-VGS)/Vpo)*(1-(2/3)*sqrt((Vbi-VGS)/Vpo)));


end Ex13_3;