model Ex3_2

parameter Real m(unit="kg")=9.11*10^(-31) "mass of electron" ;
parameter Real q(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real h(unit="J.Sec.")=1.054*10^(-34)"Planck's constant";
parameter Real pi=2*Modelica.Math.asin(1.0);
parameter Real a(unit="m")=4.5*10^(-10)"potential width";
parameter Real alpha1_a=5.141;
Real E1(unit="J");
Real E2(unit="J");
Real Eg(unit="J")"Bandgap energy in Joule";
Real Eg_1(unit="ev")"Bandgap energy in ev";

equation

E1=(pi^2*h^2)/(2*m*a^2);
E2=((alpha1_a)^2*h^2)/(2*m*a^2);
Eg=E2-E1;
Eg_1=Eg/q;

end Ex3_2;