model Ex5_1


parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=0;
parameter Real Nd(unit="cm^(-3)")=10^(16);
parameter Real ni(unit="cm^(-3)")=1.8*10^(6);
parameter Real E(unit="V/m")=10"applied electric field";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real mu_n(unit="(cm^2/V.s)")=8500"mu n of Gallium arsenide";
Real n(unit="cm^(-3)")"=electron concentration";
Real p(unit="cm^(-3)")"=hole concentration";
Real J_drf(unit="A/cm^2")"drift current density";

equation 

n=(Nd-Na)/2+sqrt(((Nd-Na)/2)^2+ni^2);
p=(ni^2)/n;
J_drf=e*mu_n*Nd*E;


end Ex5_1;