model Ex6_6

parameter Real mu_n(unit="cm^2/V-s")=1200"mobility of electron";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real Nd(unit="cm^(-3)")=10^(16);
parameter Real epsilon_not(unit="F/cm")=8.85*10^(-14)"permittivity of free space ";
parameter Real epsilon_r=11.7"relative permittivity";
Real epsilon(unit="F/cm")"permittivity of Silicon ";
Real sigma(unit="(ohm-cm)^(-1)")"conductiviy";
Real to_d(unit="s")"dielectric relaxation time constant";
equation

epsilon=epsilon_not*epsilon_r;
sigma=e*mu_n*Nd;
to_d=epsilon/sigma;

end Ex6_6;