model Ex7_4

parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=2*10^17"doping concentration";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real Emax(unit="V/cm")=2.5*10^5"Electric field in a pn junction for zero bias";
parameter Real VR(unit="V")=25"reverse-bias voltage";

Real Nd(unit="cm^(-3)")"doping concentration";

equation


Emax=(((2*e*VR)/epsilon_s)*((Na*Nd)/(Na+Nd)))^(1/2);

/*The  answer may slightly vary due to  rounding off values*/

end Ex7_4;