model Ex8_3

parameter Real T(unit="K")=300"temperature";
parameter Real To_p0(unit="s")=5*10^(-7);
parameter Real To_n0(unit="s")=5*10^(-7);
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real Dn(unit="cm^2/s")=25;
parameter Real Dp(unit="cm^2/s")=10;
parameter Real epsilon_r=11.7;
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real Va(unit="V")=0.65"voltage";
parameter Real Jn(unit="A/cm^2")=20"current density";
parameter Real Jp(unit="A/cm^2")=5"current density";

Real Na(unit="cm^(-3)")"doping concentration";
Real Nd(unit="cm^(-3)")"doping concentration";

equation

Jn=(e*ni^2)*(1/Na)*sqrt(Dn/To_n0)*(exp((e*Va)/(k*T))-1);
Jp=(e*ni^2)*(1/Nd)*sqrt(Dp/To_p0)*(exp((e*Va)/(k*T))-1);

/*The  answer may slightly vary due to  rounding off values*/
end Ex8_3;