model Ex9_5

parameter Real T(unit="K")=300"temperature";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real fi_Bn(unit="V")=0.67"actual schottky barrier height";
parameter Real Astar(unit="A/K^2-cm^2")=114"=A*=effective Richardson constant";
parameter Real To_p0(unit="s")=10^(-7);
parameter Real To_n0(unit="s")=10^(-7);
parameter Real Na(unit="cm^(-3)")=10^18"doping concentration";
parameter Real Nd(unit="cm^(-3)")=10^(16)"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real Dn(unit="cm^2/s")=25;
parameter Real Dp(unit="cm^2/s")=10;
parameter Real Lp(unit="cm")=1*10^(-3);
parameter Real Ln(unit="cm")=1.58*10^(-3);

Real p_no(unit="cm^(-3)");
Real n_po(unit="cm^(-3)");
Real Js(unit="A/cm^2")"ideal reverse-saturation current density";
Real JsT(unit="A/cm^2")"Schottky barrier diode";

equation

Astar=(JsT/T^2)*exp((e*fi_Bn)/(k*T));
n_po=ni^2/Na;
p_no=ni^2/Nd;
Js=(e*Dn*n_po)/Ln+(e*Dp*p_no)/Lp;

/*The  answer may slightly vary due to  rounding off values*/


end Ex9_5;