model Ex10_5

parameter Real T(unit="K")=300"temperature";
parameter Real Nd(unit="cm^(-3)")=10^17"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real epsilon_ox(unit="F.cm^(-1)")=3.9*8.85*10^(-14);
parameter Real t_ox(unit="cm")=120*10^(-8)"thickness";
parameter Real Q_des_ss(unit="C/cm^2")=2*10^10;
parameter Real fi_ms(unit="V")=1.1"=fi_ms";

Real Vt(unit="ev");
Real fi_fp(unit="V");
Real x_dT(unit="cm")"space charge width";
Real QdesSD_max(unit="C/cm^2")"=|Q'SD(max)|";
Real V_TP(unit="V")"Threshold voltage";

equation

Vt=(k*T)/e;
fi_fp=Vt*log(Nd/ni);
x_dT=sqrt((4*epsilon_s*fi_fp)/(e*Nd));
QdesSD_max=e*Nd*x_dT;
V_TP=(-QdesSD_max-Q_des_ss*e)*(t_ox/epsilon_ox)+fi_ms-2*fi_fp;

// Unit of Q'ss is wrong in the book 
end Ex10_5;