model Ex10_6

parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=10^16"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real epsilon_ox(unit="F.cm^(-1)")=3.9*8.85*10^(-14);
parameter Real t_ox(unit="cm")=180*10^(-8)"thickness";

Real Cdes_min(unit="F/cm^2")"=C'min";
Real X"=C'min/Cox";
Real Cdes_FB(unit="F/cm^2")"flat-band capacitance";
Real Y"=C'FB/Cox";
Real Vt(unit="ev");
Real fi_fp(unit="V");
Real x_dT(unit="cm")"space charge width";
Real Cox(unit="F/cm^2");

equation

Cox=epsilon_ox/t_ox;
Vt=(k*T)/e;
fi_fp=Vt*log(Na/ni);
x_dT=sqrt((4*epsilon_s*fi_fp)/(e*Na));
Cdes_min=epsilon_ox/((t_ox+(epsilon_ox/epsilon_s)*x_dT));
X=Cdes_min/Cox;
Cdes_FB=epsilon_ox/((t_ox+(epsilon_ox/epsilon_s)*sqrt((Vt*epsilon_s)/(e*Na))));
Y=Cdes_FB/Cox;

end Ex10_6;