model Ex11_5

parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=10^16"doping concentration";
parameter Real Nd(unit="cm^(-3)")=10^(19)"doping concentration";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real L(unit="cm")=1.2*10^(-4);
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);

Real Vbi(unit="V")"built-in potential barrier";
Real x_do(unit="cm")"space charge width";
Real x_d(unit="cm");
Real V_DS(unit="V")"punch-through voltage";
equation


Vbi=(k*T/e)*log(Na*Nd/ni^2);
x_do=((2*epsilon_s*Vbi)/(e*Na))^(1/2);
x_d=((2*epsilon_s*(Vbi+V_DS))/(e*Na))^(1/2);
x_do+x_d=L;


end Ex11_5;