model Ex12_8

parameter Real NB(unit="cm^(-3)")=5*10^16"doping concentration";
parameter Real NC(unit="cm^(-3)")=2*10^(15);
parameter Real DB(unit="cm^(2)/s")=25;
parameter Real xBO(unit="cm")=0.70*10^(-4);
parameter Real V_BE(unit="V")=0.60;
parameter Real V_CB1(unit="V")=2;
parameter Real V_CB2(unit="V")=10;
parameter Real x_dB1(unit="cm")=0.0518*10^(-4);
parameter Real x_dB2(unit="cm")=0.103*10^(-4);
parameter Real T(unit="K")=300"temperature";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);

Real Vt(unit="ev");
Real n_BO(unit="cm^(-3)");
Real xB1(unit="cm")"=xB";
Real xB2(unit="cm")"=xB";
Real Jc1(unit="A/cm^2")"=|Jc|";
Real Jc2(unit="A/cm^2")"=|Jc|";
Real VA(unit="V")"Early Voltage";

equation

n_BO=ni^2/NB;
xB1=xBO-x_dB1;
xB2=xBO-x_dB2;
Vt=k*T/e;
Jc1=((e*DB*n_BO)/xB1)*exp(V_BE/Vt);
Jc2=((e*DB*n_BO)/xB2)*exp(V_BE/Vt);
(Jc2-Jc1)/(V_CB2-V_CB1)=Jc1/(V_BE+V_CB1+VA);
/*The  answer may slightly vary due to  rounding off values*/
end Ex12_8;