model Ex13_5

parameter Real Nc(unit="cm^(-3)")=4.7*10^17"doping concentration";
parameter Real Nd(unit="cm^(-3)")=2*10^15"doping concentration";
parameter Real T(unit="K")=300"temperature";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real epsilon_s(unit="F.cm^(-1)")=13.1*8.85*10^(-14);
parameter Real VT(unit="V")=0.25;
parameter Real fi_Bn(unit="V")=0.89;

Real Vpo(unit="V")"voltage";
Real Vbi(unit="V")"built-in potential barrier";
Real Vt(unit="V");
Real a(unit="cm")"channel thickness";
Real fi_n(unit="V");

equation

Vpo=e*a^2*Nd/(2*epsilon_s);
Vt=k*T/e;
fi_n=Vt*log(Nc/Nd);
Vbi=fi_Bn-fi_n;
Vpo=Vbi-VT;

end Ex13_5;