model Ex14_3

parameter Real To_p0(unit="s")=10^(-7);
parameter Real To_n0(unit="s")=5*10^(-7);
parameter Real Na(unit="cm^(-3)")=5*10^18"doping concentration";
parameter Real Nd(unit="cm^(-3)")=10^(16)"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real Dn(unit="cm^2/s")=25;
parameter Real Dp(unit="cm^2/s")=10;
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real JL(unit="A/cm^2")=15*10^(-3);
parameter Real Ln(unit="cm")=35.4*10^(-4);
parameter Real Lp(unit="cm")=10*10^(-4);
parameter Real T(unit="K")=300"temperature";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";

Real Js(unit="A/cm^2")"reverse-saturation current density";
Real Vt(unit="eV");
Real Voc(unit="V")"open circuit voltage";

equation

Js=(e*ni^2)*((1/Na)*(Dn/Ln)+(1/Nd)*(Dp/Lp));
Vt=k*T/e;
Voc=Vt*log(1+JL/Js);

end Ex14_3;