model Ex15_1

parameter Real RL(unit="ohm")=10;
parameter Real Vcc(unit="V")=35;

Real Ic_max(unit="A")"Maximum collector current";
Real Ic(unit="A")"collector current";
Real VCE_max(unit="V")"maximum collector-emitter voltage";
Real VCE(unit="V")"collector-emitter voltage";
Real PT(unit="W")"maximum power dissipated";

equation

Ic_max=Vcc/RL;
VCE_max=Vcc;
Ic=Vcc/(2*RL);
VCE=Vcc-Ic*RL;
PT=VCE*Ic;

end Ex15_1;