model Ex4_5

parameter Real T(unit="K")=300"temperature";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real Ev1(unit="ev")=0;
parameter Real Ef(unit="ev")=0.25"Fermi energy";
parameter Real Nv(unit="cm^(-3)")=1.04*10^(19);
parameter Real Ev2(unit="ev")=1.12"bandgap energy of silicon";
parameter Real Nc(unit="cm^(-3)")=2.8*10^(19);
parameter Real q(unit="coulomb")=1.6*10^(-19)"Charge of electron";
Real kT(unit="ev");
Real n0(unit="cm^(-3)")"=electron concentration";

Real p0(unit="cm^(-3)")"=hole concentration";
equation

n0=Nc*exp(-((Ef-Ev1)/(kT)));
p0=Nv*exp(-((Ev2-Ef)/(kT)));
kT=(k*T/q);

/*The  answer may slightly vary due to  rounding off values*/

end Ex4_5;