model Ex4_7

parameter Real T(unit="K")=300"temperature";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real Ec_Ed(unit="ev")=0.045;
parameter Real Nd(unit="cm^(-3)")=10^(16);
parameter Real Nc(unit="cm^(-3)")=2.8*10^(19);
parameter Real q(unit="coulomb")=1.6*10^(-19)"Charge of electron";
Real kT(unit="ev");
Real nd_n0_nd(unit="")"=Fraction of total electrons";
Real nd_n0_nd_1(unit="%")"=Fraction of total electrons in percentage";

equation

nd_n0_nd=1/(1+(Nc/(2*Nd))*exp(-((Ec_Ed)/(kT))));
nd_n0_nd_1=nd_n0_nd*100;
kT=(k*T/q);
/*The  answer may slightly vary due to  rounding off values*/

end Ex4_7;