model Ex6_7

parameter Real p0(unit="cm^(-3)")=10^5;
parameter Real n0(unit="cm^(-3)")=10^15;
parameter Real ni(unit="cm^(-3)")=10^10;
parameter Real delta_n(unit="cm^(-3)")=10^13;
parameter Real delta_p(unit="cm^(-3)")=10^13;
parameter Real T(unit="K")=300"temperature";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
Real EF_EFi(unit="ev")"Fermi level for thermal equilibrium";
Real EFn_EFi(unit="ev")"Fermi level for electron equilibrium";
Real EFi_EFp(unit="ev")"Fermi level for hole in equilibrium";

equation

EF_EFi=(k*T/e)*log(n0/ni);
EFn_EFi=(k*T/e)*log((n0+delta_n)/ni);
EFi_EFp=(k*T/e)*log((p0+delta_p)/ni);

end Ex6_7;