model Ex9_4

parameter Real T(unit="K")=300"temperature";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real fi_Bn(unit="V")=0.67"actual schottky barrier height";
parameter Real JsT(unit="A/cm^2")=6*10^(-5);

Real Astar(unit="A/K^2-cm^2")"=A*=effective Richardson constant";

equation

Astar=(JsT/T^2)*exp((e*fi_Bn)/(k*T));

/*The  answer may slightly vary due to  rounding off values*/

end Ex9_4;