model Ex10_14

extends Modelica.Math;
// Variables
Real V1(unit ="m^3")                 "Volume at point 1";
Real n(unit ="")                     "Index of compression process";
Real m(unit ="kg")                   "Mass";
Real T2(unit ="K")                   "Temperature at point 2";
Real T3(unit ="K")                   "Temperature at point 3";
Real S1_2(unit ="kJ/kg*K")           "Entropy change";
Real S2_3(unit ="kJ/kg*K")           "Entropy change";
Real Q(unit ="kJ")                   "Heat transfer during polytropic compression process";

// Parameters
  
  parameter Real p1(unit ="kPa")=100               "Pressure at point 1";
  parameter Real p2(unit ="kPa")=1500              "Pressure at point 2";
  parameter Real p3(unit ="kPa")=5000              "Pressure at point 3";
  parameter Real V2(unit ="m^3")=100e-06           "Volume at point 2";
  parameter Real T1(unit ="K")=348                 "Temperature at point 1";
  parameter Real Cv(unit ="KJ/kg K")=0.718         "Specific heat at constant volume";
  parameter Real R(unit ="KJ/kg K")=0.287          "Gas constant";
  parameter Real y(unit ="")=1.4                   "Specific heat ratio";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

V1=8*V2;
n=log(p2/p1)/log(V1/V2);
m=p1*V1/(R*T1);
T2=T1*p2*V2/(p1*V1);
T3=T2*(p3/p2);
S1_2=m*(Cv*log(T2/T1)+R*log(V2/V1));
S2_3=m*(Cv*log(T3/T2));
Q=m*Cv*(y-n)*(T2-T1)/(1-n);

//It may contain rounding off error.

end Ex10_14;
