model Ex10_15

extends Modelica.Math;
// Variables
Real R_CO2(unit ="kJ/kg*K")          "Gas constant for oxygen";
Real R_N2(unit ="kJ/kg*K")           "Gas constant for nitrogen";
Real n_CO2(unit ="")                 "";
Real n_N2(unit ="")                  "";
Real n(unit ="")                     "";
Real x_CO2(unit ="")                 "Mole fraction";
Real x_N2(unit ="")                  "Mole fraction";
Real M(unit ="kg/kg mol")            "Equivalent molecular weight of the mixture";
Real m(unit ="kg")                   "Total mass";
Real R(unit ="kJ/kg*K")              "Gas constant";
Real P_CO2(unit ="kPa")              "Pressure of carbon dioxide";
Real P_N2(unit ="kPa")               "Pressure of nitrogen";
Real V_CO2(unit ="m^3")              "Volume of carbon dioxide";
Real V_N2(unit ="m^3")               "Volume of nitrogen";
Real V(unit ="m^3")                  "Volume of mixture";
Real rho(unit ="kg/m^3")             "Density of mixture";
Real Cv_CO2(unit ="kJ/kg*K")         "Specific heat of carbondioxide at constant volume";
Real Cp_CO2(unit ="kJ/kg*K")         "Specific heat of carbondioxide at constant pressure";
Real Cv_N2(unit ="kJ/kg*K")          "Specific heat of nitrogen at constant volume";
Real Cp_N2(unit ="kJ/kg*K")          "Specific heat of nitrogen at constant pressure";
Real Cv(unit ="kJ/kg*K")             "Specific heat at constant volume";
Real Cp(unit ="kJ/kg*K")             "Specific heat at constant pressure";
Real delta_U(unit ="kJ")             "Change in internal energy";
Real delta_H(unit ="kJ")             "Change in enthalpy";
Real delta_S(unit ="kJ/kg*K")        "Change in entropy";
Real delta_s(unit ="kJ/kg*K")        "Change in entropy";


// Parameters
  
  parameter Real m_CO2(unit ="kg")=5               "Mass of carbondioxide";
  parameter Real m_N2(unit ="kg")=3                "Mass of nitrogen";
  parameter Real R0(unit ="kJ/kg*K")=8.3143        "Gas constant";
  parameter Real M_CO2(unit ="")=44                "Mole of carbondioxide";
  parameter Real M_N2(unit ="")=28                 "Mole of nitrogen";
  parameter Real y_CO2(unit ="")=1.286             "Specific heat ratio of carbondioxide";
  parameter Real y_N2(unit ="")=1.4                "Specific heat ratio of nitrogen";
  parameter Real T1(unit ="K")=293                 "Temperature";
  parameter Real T2(unit ="K")=313                 "Temperature";
  parameter Real P(unit ="kPa")=300                "Pressure";
 
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation
R_CO2=R0/M_CO2;
R_N2=R0/M_N2;
n_CO2=m_CO2/M_CO2;
n_N2=m_N2/M_N2;
n=n_CO2+n_N2;
x_CO2=n_CO2/n;
x_N2=n_N2/n;
M=x_CO2*M_CO2+x_N2*M_N2;
m=m_CO2+m_N2;
R=((m_CO2*R_CO2)+(m_N2*R_N2))/m;
P_CO2=x_CO2*P;
P_N2=x_N2*P;
V_CO2=m_CO2*R_CO2*T1/P;
V_N2=m_N2*R_N2*T1/P;
V=V_CO2+V_N2;
rho=m/V;
Cv_CO2=R_CO2/(y_CO2-1);
Cp_CO2=y_CO2*Cv_CO2;
Cv_N2=R_N2/(y_N2-1);
Cp_N2=y_N2*Cv_N2;
Cp=(m_CO2*Cp_CO2+m_N2*Cp_N2)/m;
Cv=(m_CO2*Cv_CO2+m_N2*Cv_N2)/m;
//If the mixture is heated at constant volume
delta_U=m*Cv*(T2-T1);
delta_H=m*Cp*(T2-T1);
delta_S=m*Cv*log(T2/T1);
//If the mixture is heated at constant pressure, delta_U and delta_H will remain same.
delta_s=m*Cp*log(T2/T1);

end Ex10_15;
